(function($) {
/**
 * 配列処理
 *
 * @class 配列処理
 */
neo.array = {
    /**
     * オブジェクトのキーの配列を取得する。
     *
     * @param {Object} obj [IN]:オブジェクト
     * @return {Array} キーの配列
     */
    getKeyArray: function(obj) {
        var arr = [];
        for (var key in obj) {
            arr.push(key);
        }
        return arr;
    },

    /**
     * オブジェクトの値の配列を取得する。
     *
     * @param {Object} obj [IN]:オブジェクト
     * @return {Array} 値の配列
     */
    getValueArray: function(obj) {
        var arr = [];
        for (var key in obj) {
            arr.push(obj[key]);
        }
        return arr;
    },

    /**
     * 配列から指定した値(単数)の要素を削除する。
     *
     * @param {String}    text       [IN]:文字列
     * @param {Var}       value      [IN]:削除する値(単数)
     * @param {Function?} comparator [IN]:比較関数(配列要素, 削除する値)
     * @return {Array} 変更後の配列
     */
    remove: function(arr, value, comparator) {
        return this.subtract(arr, [value], comparator);
    },

    /**
     * 配列から指定した値(複数)の要素を削除する。
     *
     * @param {Array}     arr        [IN]:配列
     * @param {Array}     values     [IN]:削除する値(複数)
     * @param {Function?} comparator [IN]:比較関数(配列要素, 削除する値)
     * @return {Array} 変更後の配列
     */
    subtract: function(arr, values, comparator) {
        var n = arr.length;
        var newArr = [];
        var func = $.isFunction(comparator) ? comparator : function(a, b) {return a == b; };
        for (var i = 0;i < n;i++) {
            if (!this._hasItemInv(arr[i], values, func)) {
                newArr.push(arr[i]);
            }
        }
        return newArr;
    },

    /**
     * 配列に指定した値があるかどうかを取得する(引数が逆)。
     *
     * @param {Var}       value      [IN]:値
     * @param {Array}     arr        [IN]:配列
     * @param {Function?} comparator [IN]:比較関数(値, 配列要素)
     * @return {Boolean} あればtrue
     */
    _hasItemInv: function(value, arr, comparator) {
        var n = arr.length;
        for (var i = 0;i < n;i++) {
            if (comparator(value, arr[i])) {
                return true;
            }
        }
        return false;
    }
};
})(jQuery);